<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/">
	<html>
		<head>
			<script language='JavaScript'>
				function load() {
					var svgDoc= document.svg1.getSVGDocument();
					var svgObj = svgDoc.getDocumentElement();
					var vbox = svgObj.getAttribute('viewBox');
					vbox = vbox.split(" ");
					if (vbox[2] > document.body.clientWidth * 1/1.5 - 20) {
						document.svg1.style.width = document.body.clientWidth - 20;
						document.svg1.style.height = ((document.body.clientWidth - 20) / vbox[2] * vbox[3]);
					} else {
						document.svg1.style.width = vbox[2] * 1.5;
						document.svg1.style.height = vbox[3] * 1.5;
					}
					document.svg1.DefaultAntialias = "0";
				}
			</script>
			<style>
				body{
					background-color: #FFFFFF;
					margin: 10px;
					font-family: Arial, Helvetica;
					font-size: 9pt;
				}
				table {
					font-family: Arial, Helvetica;
					font-size: 9pt;
					line-height: 12pt;
				}
			</style>
		</head>
		<xsl:element name="body"> 
			<xsl:if test="//BLOCKFIG[. != ''] and contains(//BLOCKFIG,'.svgz')">
				<xsl:attribute name="onLoad">load();</xsl:attribute>
				<xsl:attribute name="onResize">load();</xsl:attribute>
			</xsl:if>
			<table width="100%" border="0" cellspacing="0" cellpadding="1">
				<tr nowrap="nowrap">
					<th width="100" align="left">Part No</th>
					<td><xsl:value-of select="//PARTNO"/></td>
				</tr>
				<tr nowrap="nowrap">
					<th width="100" align="left">Information</th>
					<td><xsl:value-of select="//INFO"/></td>
				</tr>
				<tr nowrap="nowrap">
					<th width="100" align="left">Note</th>
					<td><xsl:value-of select="//NOTE"/></td>
				</tr>
				<xsl:if test="//BLOCKFIG[. != '']"> 
					<tr nowrap="nowrap">
						<th width="100" align="left" nowrap="nowrap">Block Diagram</th>
						<td></td>
					</tr>
				</xsl:if>
			</table>
			<xsl:if test="//BLOCKFIG[. != '']"> 
				<p align="center">
				<xsl:if test="contains(//BLOCKFIG,'.svgz')">
					<embed align="middle">
						<xsl:attribute name="src"><xsl:value-of select="//BLOCKFIG"/></xsl:attribute>
						<xsl:attribute name="name">svg1</xsl:attribute>
					</embed>
				</xsl:if>
				<xsl:if test="contains(//BLOCKFIG,'.png') or contains(//BLOCKFIG,'.gif') or contains(//BLOCKFIG,'.bmp')">
					<img align="middle">
						<xsl:attribute name="src"><xsl:value-of select="//BLOCKFIG"/></xsl:attribute>
					</img>
				</xsl:if>
				</p>
			</xsl:if>
			<b>Pin Function</b><br/>
			<table width='100%' border='1' cellspacing='0' cellpadding='1' bordercolordark='#FFFFFF' bordercolor='#777777'>
				<tr style='color:captiontext;' bgcolor='activecaption'>
					<th>Pin</th>
					<th>Label</th>
					<th>I/O</th>
					<th>Description</th>
				</tr>
				<xsl:apply-templates select="/ICTABLE/ROW">
					<xsl:sort select="ID" order="ascending"/>
				</xsl:apply-templates>
			</table>
		</xsl:element> 
	</html>
</xsl:template>

<xsl:template match="/ICTABLE/ROW">
	<tr> 
		<td align="center" nowrap="nowrap">
			<xsl:if test="PINNO[. != '']"><xsl:call-template name="text"><xsl:with-param name="content"><xsl:value-of select="PINNO"/></xsl:with-param></xsl:call-template></xsl:if>
			<xsl:if test="PINNO[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="LABEL[. != '']"><xsl:call-template name="text"><xsl:with-param name="content"><xsl:value-of select="LABEL"/></xsl:with-param></xsl:call-template></xsl:if>
			<xsl:if test="LABEL[. = '']"><br/></xsl:if>
		</td>
		<td align="center" nowrap="nowrap">
			<xsl:if test="IO[. != '']"><xsl:call-template name="text"><xsl:with-param name="content"><xsl:value-of select="IO"/></xsl:with-param></xsl:call-template></xsl:if>
			<xsl:if test="IO[. = '']"><br/></xsl:if>
		</td>
		<td>
			<xsl:if test="DESCRIPTION[. != '']"><xsl:call-template name="text"><xsl:with-param name="content"><xsl:value-of select="DESCRIPTION"/></xsl:with-param></xsl:call-template></xsl:if>
			<xsl:if test="DESCRIPTION[. = '']"><br/></xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="text">
	<xsl:param name="content" select="."/>
	<xsl:value-of select="substring-before($content, '&#10;')"/>
	<xsl:choose>
		<xsl:when test="contains($content, '&#10;')">
			<br/>
			<xsl:call-template name="text">
				<xsl:with-param name="content" select="substring-after($content, '&#10;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="string-length($content) &gt; 0">
			<xsl:value-of select="$content"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
